/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.cache;

import java.util.Map;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.cache.model.BakedGeoModel;

public record BakedModelCache(Map<class_2960, BakedGeoModel> cache) {
    public BakedGeoModel getModel(class_2960 modelFile) {
        BakedGeoModel model = this.cache.get(modelFile);
        if (model == null) {
            class_2960 strippedPath = BakedModelCache.stripLegacyPath(modelFile);
            if (!modelFile.equals((Object)strippedPath)) {
                GeckoLibConstants.LOGGER.error("Superfluous prefix or suffix found in model resource path: '{}'. Should be '{}'", (Object)modelFile, (Object)strippedPath);
                model = this.cache.get(strippedPath);
            }
            if (model == null) {
                throw new IllegalArgumentException("Unable to find model file: " + String.valueOf(modelFile));
            }
        }
        return model;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    private static class_2960 stripLegacyPath(class_2960 legacyPath) {
        String path = legacyPath.method_12832();
        if (path.startsWith("geckolib/")) {
            path = path.substring(9);
        }
        if (path.startsWith("models/")) {
            path = path.substring(7);
        }
        if (path.endsWith(".json")) {
            path = path.substring(0, path.length() - 5);
        }
        if (path.endsWith(".geo")) {
            path = path.substring(0, path.length() - 4);
        }
        return !path.equals(legacyPath.method_12832()) ? legacyPath.method_45136(path) : legacyPath;
    }
}

